<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');
?>
<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'main_configuration', JText::_('COM_TIMETABLE_MAIN_CONFIGURATION', true)); ?>
<div id="tab-main">
	<table class="form-table">
		<tbody>
			<tr valign="top">
				<th scope="row">
					<label for="event">
						<?php echo JText::_("COM_TIMETABLE_EVENTS"); ?>
					</label>
				</th>
				<td>
					<select name="event" id="event" multiple="multiple">
						<?php
						foreach($this->events as $event){
							echo "<option value='{$event->alias}'>{$event->title} (id: {$event->id})</option>";
						}
						?>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_EVENTS_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="event">
						<?php echo JText::_("COM_TIMETABLE_EVENT_CATEGORIES"); ?>
					</label>
				</th>
				<td>
					<select name="event_category" id="event_category" multiple="multiple">
						<?php 
						foreach($this->event_categories as $event_category){
							echo "<option value='{$event_category->alias}'>{$event_category->title}</option>";
						}
						?>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_EVENT_CATEGORIES_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="hour_category">
						<?php echo JText::_("COM_TIMETABLE_HOUR_CATEGORIES"); ?>
					</label>
				</th>
				<td>
					<select name="hour_category" id="hour_category" multiple="multiple">
						<?php
						foreach($this->hour_categories as $hour_category){
							echo "<option value='{$hour_category->category}'>{$hour_category->category}</option>";
						}
						?>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_HOUR_CATEGORIES_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="weekdays">
						<?php echo JText::_("COM_TIMETABLE_COLUMNS"); ?>
					</label>
				</th>
				<td>
					<select name="weekday" id="weekday" multiple="multiple">
						<?php 
						foreach($this->columns as $column){
							echo "<option value='{$column->alias}'>{$column->title} (id: {$column->id})</option>";
						}
						?>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_COLUMNS_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="measure">
						<?php echo JText::_("COM_TIMETABLE_HOUR_MEASURE", true); ?>
					</label>
				</th>
				<td>
					<select name="measure" id="measure">
						<option value="1"><?php echo JText::_("Hour (1h)", true); ?></option>
						<option value="0.5"><?php echo JText::_("Half hour (30min)", true); ?></option>
						<option value="0.25"><?php echo JText::_("Quarter hour (15min)", true); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_HOUR_MEASURE_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="filter_style">
						<?php echo JText::_("COM_TIMETABLE_FILTER_STYLE"); ?>
					</label>
				</th>
				<td>
					<select name="filter_style" id="filter_style">
						<option value="dropdown_list"><?php echo JText::_("COM_TIMETABLE_FILTER_STYLE_DROPDOWN"); ?></option>
						<option value="tabs"><?php echo JText::_("COM_TIMETABLE_FILTER_STYLE_TABS"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_FILTER_STYLE_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="filter_kind">
						<?php echo JText::_("COM_TIMETABLE_FILTER_KIND"); ?>
					</label>
				</th>
				<td>
					<select name="filter_kind" id="filter_kind">
						<option value="event"><?php echo JText::_("COM_TIMETABLE_FILTER_KIND_EVENT"); ?></option>
						<option value="event_category"><?php echo JText::_("COM_TIMETABLE_FILTER_KIND_EVENT_CATEGORY"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_FILTER_KIND_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="filter_label">
						<?php echo JText::_("COM_TIMETABLE_FILTER_LABEL"); ?>
					</label>
				</th>
				<td>
					<input type="text" class="regular-text" value="<?php echo JText::_("COM_TIMETABLE_FILTER_LABEL_DEFAULT"); ?>" id="filter_label" name="filter_label">
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_FILTER_LABEL_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="time_format">
						<?php echo JText::_("COM_TIMETABLE_TIME_FORMAT"); ?>
					</label>
				</th>
				<td>
					<fieldset>
						<label title="H.i">
							<input type="radio" checked="checked" value="H.i" name="time_format"> 
							<span>09.03 (H.i)</span>
						</label>
						<label title="H:i">
							<input type="radio" value="H:i" name="time_format"> 
							<span>09:03 (H:i)</span>
						</label>
						<label title="g:i a">
							<input type="radio" value="g:i a" name="time_format"> 
							<span>9:03 am (g.i a)</span>
						</label>
						<label title="g:i A">
							<input type="radio" value="g:i A" name="time_format"> 
							<span>9:03 AM (g.i A)</span>
						</label>
						<label>
							<input type="radio" value="custom" id="time_format_custom_radio" name="time_format"> 
							<?php echo JText::_("Custom: ", true); ?>
							<input type="text" class="small-text" value="H.i" name="time_format_custom" id="time_format">
							<span class="example"> 9:03 am</span>
							<img class="spinner" src="<?php echo COM_TIMETABLE_IMAGES_URL . "ajax-loader.gif"; ?>">
						</label>
					</fieldset>
				</td>
				<td></td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="hide_hours_column">
						<?php echo JText::_("COM_TIMETABLE_HIDE_HOURS_COLUMN"); ?>
					</label>
				</th>
				<td>
					<select name="hide_hours_column" id="hide_hours_column">
						<option value="0"><?php echo JText::_("COM_TIMETABLE_NO"); ?></option>
						<option value="1"><?php echo JText::_("COM_TIMETABLE_YES"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_HIDE_HOURS_COLUMN_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="show_end_hour">
						<?php echo JText::_("COM_TIMETABLE_SHOW_END_HOUR"); ?>
					</label>
				</th>
				<td>
					<select name="show_end_hour" id="show_end_hour">
						<option value="0"><?php echo JText::_("COM_TIMETABLE_NO"); ?></option>
						<option value="1"><?php echo JText::_("COM_TIMETABLE_YES"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_SHOW_END_HOUR_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="event_layout">
						<?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT"); ?>
					</label>
				</th>
				<td>
					<select name="event_layout" id="event_layout">
						<option value="1"><?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT_TYPE_1"); ?></option>
						<option value="2"><?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT_TYPE_2"); ?></option>
						<option value="3"><?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT_TYPE_3"); ?></option>
						<option value="4"><?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT_TYPE_4"); ?></option>
						<option value="5"><?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT_TYPE_5"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_EVENT_BLOCK_LAYOUT_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="hide_empty">
						<?php echo JText::_("COM_TIMETABLE_HIDE_EMPTY_ROWS"); ?>
					</label>
				</th>
				<td>
					<select name="hide_empty" id="hide_empty">
						<option value="0"><?php echo JText::_("COM_TIMETABLE_NO"); ?></option>
						<option value="1"><?php echo JText::_("COM_TIMETABLE_YES"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_HIDE_EMPTY_ROWS_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="disable_event_url">
						<?php echo JText::_("COM_TIMETABLE_DISABLE_EVENT_URL"); ?>
					</label>
				</th>
				<td>
					<select name="disable_event_url" id="disable_event_url">
						<option value="0"><?php echo JText::_("COM_TIMETABLE_NO"); ?></option>
						<option value="1"><?php echo JText::_("COM_TIMETABLE_YES"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_DISABLE_EVENT_URL_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="text_align">
						<?php echo JText::_("COM_TIMETABLE_TEXT_ALIGN"); ?>
					</label>
				</th>
				<td>
					<select name="text_align" id="text_align">
						<option value="center"><?php echo JText::_("COM_TIMETABLE_TEXT_ALIGN_CENTER"); ?></option>
						<option value="left"><?php echo JText::_("COM_TIMETABLE_TEXT_ALIGN_LEFT"); ?></option>
						<option value="right"><?php echo JText::_("COM_TIMETABLE_TEXT_ALIGN_RIGHT"); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_TEXT_ALIGN_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="row_height">
						<?php echo JText::_("COM_TIMETABLE_ID", true); ?>
					</label>
				</th>
				<td>
					<input type="text" class="regular-text" value="" id="id" name="id">
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_ID_DESCRIPTION"); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="row_height">
						<?php echo JText::_("COM_TIMETABLE_ROW_HEIGHT", true); ?>
					</label>
				</th>
				<td>
					<input type="text" class="regular-text" value="31" id="row_height" name="row_height">
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_ROW_HEIGHT_DESCRIPTION", true); ?></span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="responsive">
						<?php echo JText::_("COM_TIMETABLE_RESPONSIVE"); ?>
					</label>
				</th>
				<td>
					<select name="responsive" id="responsive">
						<option value="1"><?php echo JText::_("COM_TIMETABLE_YES", true); ?></option>
						<option value="0"><?php echo JText::_("COM_TIMETABLE_NO", true); ?></option>
					</select>
				</td>
				<td>
					<span class="description"><?php echo JText::_("COM_TIMETABLE_RESPONSIVE_DESCRIPTION"); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div>
<?php echo JHtml::_('bootstrap.endTab'); ?>